/*
 * Decompiled with CFR 0.152.
 */
package com.tianti;

import android.content.Context;
import android.util.Log;
import com.tianti.CrashHandler;
import com.tianti.LoggerCallback;
import com.tianti.SyncHttp;
import com.tianti.util.DeviceInfo;

public class AppLogger {
    public static final String STAGE_NULL = "@null";
    public static final String STAGE_MAX = "@max";
    public static final String STAGE_LAST = "@last";
    public static final String STAGE_CURRENT = "@current";
    public static final int DEBUG_MODE_OFF = 0;
    public static final int DEBUG_MODE_LOGCAT = 1;
    public static final int DEBUG_MODE_LOGFILE = 2;
    public static final int DEBUG_MODE_LOGALL = 3;
    public static final int DEBUG_LEVEL_VERBOSE = 0;
    public static final int DEBUG_LEVEL_INFO = 1;
    public static final int DEBUG_LEVEL_WARN = 2;
    public static final int DEBUG_LEVEL_ERROR = 3;
    private static boolean loadOK = true;
    public static LoggerCallback logCallback;
    private static final String BASE_URL = "http://";
    private static String LOG_TAG;

    public static void log(String string) {
        if (logCallback != null) {
            logCallback.recv(string);
        }
    }

    public static void setContext(Context context) {
        DeviceInfo.init(context);
        AppLogger.setEnv();
    }

    public static void init(Context context) {
        AppLogger.setContext(context);
        AppLogger.onInit(null, null);
        CrashHandler.setup(false);
    }

    public static void init(Context context, String string, String string2) {
        AppLogger.setContext(context);
        AppLogger.onInit(string, string2);
        CrashHandler.setup(false);
    }

    private static native void setEnv();

    private static native void onInit(String var0, String var1);

    public static native void setDebugLog(int var0, int var1);

    public static native void setSessionInterval(int var0);

    public static native void setOnline(boolean var0);

    public static native void enableCrashReport();

    public static native void enableOnlineConfig();

    public static native String getOnlineConfig(String var0, String var1);

    public static native void onPostSuccess();

    public static native void onPostFailure(int var0);

    public static native void onStart();

    public static native void onEnd();

    public static native void onExit();

    public static native void onEvent(String var0, String var1);

    public static native void onBalance(String var0, String var1, int var2, String var3);

    public static native void onLevelUp(String var0, String var1, String var2, String var3);

    public static native void onBuy(String var0, String var1, int var2, float var3, String var4);

    public static native void onUse(String var0, int var1, String var2);

    public static native int onSubStart(String var0);

    public static native void onSubEnd(String var0);

    public static native void onExchange(String var0, int var1, String var2);

    public static native void onCollect(String var0, int var1, String var2);

    public static native void onReward(String var0, int var1, String var2);

    public static native void onPassFail(boolean var0);

    public static native void clearStatus();

    public static native void setStatus(String var0, int var1, boolean var2);

    public static native void setUser(String var0, int var1, String var2, String var3, String var4);

    public static native void onShare(String var0, String var1, String var2);

    public static void sync(int n, String string, String string2, byte[] byArray, int n2) {
        if (string2.equals("POST")) {
            SyncHttp.POST(n, string, byArray, n2);
        } else if (string2.equals("GET")) {
            SyncHttp.GET(n, string, n2);
        }
    }

    public static void doRequest(String string) {
    }

    static {
        try {
            System.loadLibrary("logger");
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            Log.e((String)"tianti", (String)("" + unsatisfiedLinkError));
            loadOK = false;
        }
        LOG_TAG = "tianti";
    }
}

